<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">

    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
        <span aria-hidden="true">×</span>
      </button>
      <h4 class="modal-title">
        {{ __('lang_v1.invoice_no') }}: {{ $sell->invoice_no }}
        <small class="label bg-gray" style="margin-left:8px;">{{ __('lang_v1.deleted') }}</small>
      </h4>
    </div>

    <div class="modal-body">
      <div class="row">
        <div class="col-sm-6">
          <strong>{{ __('contact.customer') }}:</strong>
          {{ optional($sell->contact)->name }}
          <br>
          <strong>{{ __('business.location') }}:</strong>
          {{ optional($sell->location)->name }}
          <br>
          <strong>{{ __('sale.sale_date') }}:</strong>
          {{ @format_datetime($sell->transaction_date) }}
          <br>
          <strong>{{ __('lang_v1.deleted_at') }}:</strong>
          {{ optional($sell->deleted_at)->format('Y-m-d H:i') }}
        </div>
        <div class="col-sm-6">
          <strong>{{ __('sale.total') }}:</strong>
          @format_currency($sell->final_total)
          <br>
          <strong>{{ __('sale.payment_status') }}:</strong>
          {{ ucfirst($sell->payment_status) }}
        </div>
      </div>

      <hr>

     
            @foreach ($sell->sell_lines as $line)
              @php
                $name = !empty($line->variations) && !empty($line->variations->product_variation)
                    ? $line->product->name . ' (' . $line->variations->product_variation->name . ':' . $line->variations->name . ')'
                    : ($line->product->name ?? '');
              @endphp
              <tr>
                <td>
                  {{ $name }}
                  @if(!empty($line->sub_unit))
                    <br><small>{{ $line->sub_unit->actual_name }}</small>
                  @endif
                  @if(!empty($line->sell_line_note))
                    <br><small class="text-muted">{{ $line->sell_line_note }}</small>
                  @endif
                </td>
                <td class="text-right">@format_currency($line->unit_price_inc_tax)</td>
                <td class="text-right">@format_quantity($line->quantity)</td>
                <td class="text-right">@format_currency($line->unit_price_inc_tax * $line->quantity)</td>
              </tr>

              {{-- Optional: list modifiers if you use them --}}
              @foreach ($line->modifiers ?? [] as $mod)
                <tr>
                  <td class="text-muted">&nbsp;&nbsp;— {{ $mod->product->name ?? '' }}</td>
                  <td class="text-right text-muted">@format_currency($mod->unit_price_inc_tax)</td>
                  <td class="text-right text-muted">@format_quantity($mod->quantity)</td>
                  <td class="text-right text-muted">@format_currency($mod->unit_price_inc_tax * $mod->quantity)</td>
                </tr>
              @endforeach

            @endforeach
          </tbody>
        </table>
      </div>

      @if(!empty($order_taxes))
        <div class="row">
          <div class="col-sm-12">
            <strong>{{ __('sale.order_taxes') }}:</strong>
            <ul class="list-unstyled">
              @foreach($order_taxes as $n => $amount)
                <li>{{ $n }}: @format_currency($amount)</li>
              @endforeach
            </ul>
          </div>
        </div>
      @endif
    </div>

    <div class="modal-footer">
      <button type="button" class="btn btn-default" data-dismiss="modal">{{ __('messages.close') }}</button>
    </div>
  </div>
</div>
